#!/usr/bin/env python
from flask import Flask, render_template_string, send_file
from bandersnatch import bandersnatch

TEMPLATE = """
<!doctype html>
<html>
    <head>
        <style>
        body {
          background-color: black;
          color: white;
          font-family: sans-serif
        }
        label {
          background-color: black;
        }
        .segment {
          width:472px;
          height:266px;
        }
        div.segment {
          margin:30px
        }
        video.segment {
        }
        </style>
        <title>Bandersnatch</title>
    </head>
    <body>
        <h3>{{ length }}</h3>
        <textarea>{% for segment in concat %}
file '{{ segment }}.mkv' {% endfor %}</textarea>
        <div style='display: flex; flex-wrap: wrap;'>
        {% for option in options %}
            <div class='segment' id='{{ option.id }}' style='background-image: url({{ option.url }})'>
                <video class='segment' id='{{ option.id }}-vid' controls {% if option.url %}poster='{{ option.url }}' preload='none'{% else %}preload='metadata'{% endif %}>
                    <source src='https://s3.home.b303.me/bandersnatch/{{ option.id }}.mkv{% if not option.url %}#t=0.5{% endif %}' type='video/mp4'>
                </video>
                <label for='{{ option.id }}'>{% if option.chose != "No caption (1A)" %}<span class='chose'>Chose {{ option.chose }}</span> &gt;{% endif %} <span class='caption'>{{ option.caption }}</span></label>
            </div>
        {% endfor %}
        </div>
    </body>
</html>
"""

app = Flask(__name__)

@app.route("/<segment>.mkv")
def mkv(segment):
    return send_file("{}.mkv".format(segment))

@app.route("/")
def index():
    concat, options, length = bandersnatch()
    return render_template_string(TEMPLATE, concat=concat, options=options, length=length)

if __name__ == "__main__":
    app.run(debug=True, host="0.0.0.0", port=24572)