#!/usr/bin/env python3
# A script to generate videos for MP3s
from moviepy.editor import *
import numpy as np
from PIL import Image
from glob import glob
from mutagen.mp3 import MP3
from io import BytesIO

#points
ART_TOP_LEFT = (620,45)
ART_SIZE = (585,585)
TEXT_TOP_LEFT = (85,60)
TEXT_SIZE = (510,565)

for fn in sorted(glob("*.mp3")):
    data = MP3(fn)
    audio = AudioFileClip(fn)
    text = TextClip("You are listening to\n\n{TIT2.text[0]}\n\nBy {TPE1.text[0]}\n\nFrom {TALB.text[0]}".format(**data.tags).encode('utf8'),
                    size=TEXT_SIZE,
                    color="white",
                    font="Corbel",
                    kerning=5,
                    fontsize=50,
                    method="caption",
                    align="West").set_position(TEXT_TOP_LEFT).set_duration(audio.duration).set_audio(audio)
    cover_art = [k for k in data.tags.keys() if k[:4] == "APIC"]
    if cover_art:
        if len(cover_art) != 1:
            print("Using {} for cover art".format(cover_art[0]))
        img_input = np.asarray( Image.open( BytesIO(data.tags[cover_art[0]].data) ), dtype="int32" )
    else:
        print("Using cover.jpg for cover art")
        img_input = "cover.jpg"
    cover = ImageClip(img_input).set_position(ART_TOP_LEFT).set_duration(audio.duration).resize(ART_SIZE)
    cvc = CompositeVideoClip([text, cover], size=(1280,720)).set_fps(60)
    cvc.write_videofile(fn.replace(".mp3", ".mp4"))