from util import hook, http
import urllib
import urllib2
import json
import re

BASE_URL = "https://mediacru.sh/"
API_URL = BASE_URL + "api/"


def mediacrush_upload(address):
    try:
        data = http.get_json(API_URL + "upload/url", post_data=urllib.urlencode({'url': address}))
        return BASE_URL + data["hash"]
    except urllib2.HTTPError as e:
        data = json.loads(e.read())
        if "file" in data:
            return BASE_URL + data["file"]["original"][1:].split(".")[0]
        else:
            return data


fourchan_re = (r'(.*:)//(images.4chan.org)(.*)', re.I)

@hook.regex(*fourchan_re)
def fourchan_url(match):
    location = match.group(3)
    response = mediacrush_upload("https://images.4chan.org" + location)
    return "4chan backup: " + response
