#!/bin/bash -x
# https://gbatemp.net/download/batch-cia-3ds-decryptor.35098/
# adapted from the .bat file in this zip
# requires wine
# intended for e.g Homebrew.Game.Title/asdf.rar, produces Homebrew.Game.Title.3ds as decrypted output
_PWD=$(pwd)
DECRYPTPATH=/root
cd "$1"
unrar -o+ x $(find . -name *.rar | head -n1)
echo | wine $DECRYPTPATH/decrypt.exe *.3ds
cd $DECRYPTPATH
>/dev/null ls *.Main.ncch && arg="-i $(ls *.Main.ncch):0:0"
>/dev/null ls *.Manual.ncch && arg="$arg -i $(ls *.Manual.ncch):1:1"
>/dev/null ls *.DownloadPlay.ncch && arg="$arg -i $(ls *.DownloadPlay.ncch):2:2"
>/dev/null ls *.Partition4.ncch && arg="$arg -i $(ls *.Partition4.ncch):3:3"
>/dev/null ls *.Partition5.ncch && arg="$arg -i $(ls *.Partition5.ncch):4:4"
>/dev/null ls *.Partition6.ncch && arg="$arg -i $(ls *.Partition6.ncch):5:5"
>/dev/null ls *.N3DSUpdateData.ncch && arg="$arg -i $(ls *.N3DSUpdateData.ncch):6:6"
>/dev/null ls *.UpdateData.ncch && arg="$arg -i $(ls *.UpdateData.ncch):7:7"
echo $arg
wine $DECRYPTPATH/makerom.exe -f cci -ignoresign -target p -o "$_PWD/$1.3ds" $arg
rm *.ncch
cd $_PWD
test "$1.3ds" && rm "$1"/*.3ds