# Raptr last-played info retriever
# For use with CloudBot (http://git.io/cbgit), although it'll also work as a Python module
# (from raptr import raptr; print raptr("blha303");)
# (after removing the 'from util' and '@hook.command' lines, and switching lines 19 and 20)
#
# This file (raptr.py) created by Steven Smith (blha303) 2013
# GPLv3 license (because CloudBot is GPL)
# http://opensource.org/licenses/GPL-3.0
#
# For a working example of this, join irc.esper.net #xD and ask blha303 for a demonstration of raptr.py
# Email raptr@blha303.com.au for any questions.

from util import hook, http, web
from bs4 import BeautifulSoup as Soup

@hook.command
def raptr(inp):
    """raptr <nickname> - Looks up raptr last-played info. WIP """
#   soup = Soup(urllib2.urlopen("http://raptr.com/%s/games?sort_by=last_played" % inp).read())
    soup = http.get_soup("http://raptr.com/%s/games?sort_by=last_played" % inp)
    script = soup.findAll('script')[-5]
    data = script.text.strip()[49:].replace("\\/", "/").replace('\\"', '"')
    newsoup = Soup(data)
    rank = newsoup.find('li', {'class': 'game-rank'}).find('span').text
    if rank == "Elite":
        rank = "\x037Elite\x0f"
    elif rank == "Newbie":
        rank = "\x0315Newbie\x0f"
    elif rank == "Dedicated":
        rank = "\x0312Dedicated\x0f"
    elif rank == "Amateur":
        rank = "\x0314Amateur\x0f"
    return "%s last played %s. They have %s logged in that game (%s)." % (inp, 
                newsoup.find('a', {'class': 'game-title'}).text,
                newsoup.find('li', {'class': 'game-hours'}).text.strip(),
                rank)
