#!/usr/bin/env python2

# rtmpdump parameter generator for justin.tv/twitch.tv streams v5
# * Usage: jtvrtmp.py channelname [quality]
#   where channelname is the channel name ([twitch/justin].tv/channelname)
#   and quality is an optional parameter with a valid quality setting 
#   (360p, 480p, 720p, etc) If quality isn't present, it selects 'live'.
# * if quality is 'live', it picks the quality setting with a +, which 
#   is a restream of the video being sent to jtv, no transcoding involved.
#
# Changelog:
# v5: Changed to default to 'live' quality instead of 360p, as some streams
#     don't have 360p transcoding; made the code in main() slightly cleaner,
#     possibly shorter.
# v4: Add shebang line
# v3: Removed unicode copyright symbol
# v2: Added exception catching for when a stream is offline or the specified
#     quality setting is unavailable.
# v1: Initial release
#
# Copyright 2013 Steven Smith (blha303). All Rights Reserved.
# New BSD license
# http://www.opensource.org/licenses/BSD-3-Clause

from urllib2 import urlopen
import json
from sys import argv, exit

def getswfaddr(channelname):
  return urlopen("http://www.justin.tv/widgets/live_embed_player.swf?channel=" + channelname).geturl().split("&userAgent")[0]

def getstreaminfo(channelname):
  data = json.loads(urlopen("http://usher.justin.tv/find/%s.json?type=any" % channelname.lower()).read())
  newd = {}
  for i in data:
    newd[i['display']] = i
  return newd

def buildcmdline(channelname, data, quality="live"):
  if quality == "live":
    for i in data:
      if "+" in i:
        quality = i
  try:
    data = data[quality]
  except KeyError:
    return '; echo "-------------"; echo "Couldn\'t find stream info for %s, maybe the stream is offline?"; echo "-------------" #' % quality
  if not "live-cdn" in data["connect"] and not "justintvlivefs" in data["connect"]:
    justinlegacyparams = '-j "%s" ' % data["token"].replace('"', r'\"')
  else:
    justinlegacyparams = ""
  out = '-r "%s/%s" %s--swfVfy "%s" -o -' % (data["connect"], data["play"], justinlegacyparams, getswfaddr(channelname))
  return out

def main():
  if len(argv) < 2:
    print "Usage: %s channelname [quality]" % argv[0]
    exit(2)
  channelname = argv[1]
  data = getstreaminfo(channelname)
  if len(argv) > 2:
    print buildcmdline(channelname, data, quality=argv[2])
  else:
    print buildcmdline(channelname, data)

if __name__ == "__main__":
  main()
