# ipinfo.py by Steven Smith (blha303), MIT license (as is every script on my gist, by the way, unless otherwise stated)
# A local service to get your ip, for if you have a local service running that you want to link to other people but you can't be bothered finding your IP first.
# I use it for Plex, with a bookmark pointing to http://localhost:5212/32400/web/index.html

from flask import Flask, jsonify, redirect
import socket
app = Flask(__name__)
ip_addrs = None

def update():
    global ip_addrs
    ip_addrs = [ip for ip in socket.gethostbyname_ex(socket.gethostname())[2]
                            if not ip[:4] == "127."]

def select():
    global ip_addrs
    ips = [s for s in ip_addrs if s[:8] == "192.168."] + [s for s in ip_addrs if s[:4] == "10."] + [s for s in ip_addrs if s[:7] == "172.16."]
    if ips:
        return ips[0]
    else:
        return ip_addrs[0]

@app.route("/")
def getip():
    update()
    return jsonify(ip_addrs=ip_addrs)

@app.route("/<path:path>")
def path(path):
    update()
    return redirect("http://{}:{}".format(select(), path), code=307)

if __name__ == "__main__":
    update()
    app.run(port=5212, debug=True)