function Connect-VM {
    param(
        [Parameter(ValueFromPipeline=$true, ValueFromPipelineByPropertyName=$true, Position=1)]
        [Microsoft.HyperV.PowerShell.VirtualMachine[]]$VM,
        [switch] $PassThru
    )
    PROCESS {
        foreach ($VMobject in $VM) {
            vmconnect localhost ($VMobject.name)
        }
        if($PassThru) {$_}
    }
}

new-vmswitch -name Int
new-vm -name 'testvm' -MemoryStartupBytes 1GB -SwitchName Int
add-vmdvddrive testvm -path "t:\wineval\8.1 Eval.iso"
new-vhd -dynamic c:\testvm.vhdx -sizebytes 20GB
Add-VMHardDiskDrive testvm -path c:\testvm.vhdx
get-vm -name testvm | start-vm -passthru | connect-vm