export default {
  async fetch(request, env, ctx) {
    async function newResponse(code, msg, headers) {
      return new Response(msg, {
        status: code,
        headers: headers,
      });
    }
    // Only GET requests work with this proxy.
    if (request.method !== "GET") return newResponse(405, `Method ${request.method} not allowed.`, {
      Allow: "GET",
    });

    const { searchParams } = new URL(request.url);
    let name = searchParams.get("name"), indexes = searchParams.get("indexes") || "Item";
    if (!name) {
      return newResponse(400, "Invalid request", {});
    }

    const url = `https://xivapi.com/search?indexes=${encodeURIComponent(indexes)}&string=${encodeURIComponent(name)}`;
    const response = await fetch(url);
    const data = await response.json();
    if (data.Results.length < 1) {
        return newResponse(404, "No results", {});
    }
    return fetch(`https://xivapi.com${data.Results[0].Icon}`);
  },
};