# xMail implementation v1 by blha303
# MIT license
# irc.esper.net #drtshock for questions
import json, urllib2, urllib
url = "http://xmail.turt2live.com/mail/index.php"
from random import randrange
 
def get_password(password):
  return urllib2.urlopen("http://blha303.com.au/sha1.php?q=%s" % password).read()
# An alternative for this, on machines with PHP installed, is:
# return os.popen('echo "<?php echo sha1(\'%s\'); ?>" | php' % password).read()
# That's all the above PHP file does.
 
def get_json(url, data):
  return json.loads(urllib2.urlopen(url, data).read())
 
# xMail functions start here
 
def register(username, password):
  """username: new xmail username; password: yep"""
  registerdata = urllib.urlencode({'mode': 'REGISTER', 'username': username, 'password': get_password(password), 'version': 'IRC'})
  register = get_json(url, registerdata)
  return register
# Returns:
# {u'status': u'OK', u'username': u'USERNAME REMOVED', u'loggedin': True, u'apikey': u'API KEY REMOVED', u'lastlogin': 1373054388, u'date': 1373054388, u'message': u'User registered'}
 
def login(username, password):
  """Initial login"""
  logindata = urllib.urlencode({'mode': 'LOGIN', 'username': username, 'password': get_password(password), 'version': 'IRC'})
  login = get_json(url, logindata)
  return login
# Returns:
# {u'status': u'OK', u'username': u'USERNAME REMOVED', u'loggedin': True, u'apikey': u'API KEY REMOVED', u'lastlogin': u'1373009275', u'date': 1373009330, u'message': u'Logged in'}
 
def check_login(username):
  """Renews login, retrieves updated api key"""
  checkdata = urllib.urlencode({'mode': 'CHECK_LOGIN', 'username': username, 'version': 'IRC'})
  check = get_json(url, checkdata)
  return check
# Returns same as login(), used for verifying login status and retrieving updated API key
 
def send(fromuser, to, message):
  """fromuser: xmail username of sending user; to: xmail username of receiving user; message: yep"""
  apikey = check_login(username)['apikey']
  pid = randrange(1, 1001)
  uid = randrange(1, 1001)
  ident = "S"
  version = "IRC"
  senddata = urllib.urlencode({'mode': 'SEND', 'pid': pid, 'uid': uid, 'ident': ident, 'to': to, 'from': fromuser, 'message': message, 'apikey': apikey, 'version': version})
  send = get_json(url, senddata)
  return send
# Returns:
# {u'status': u'OK', u'message': u'Message sent!'}
 
def inbox(username):
  """Returns list of inbox entries. See below example"""
  apikey = check_login(username)['apikey']
  version = "IRC"
  inboxdata = urllib.urlencode({'mode': 'INBOX', 'username': username, 'apikey': apikey, 'version': version})
  # The one special case
  inbox = urllib2.urlopen(url, inboxdata).read().split("\n")
  inboxa = []
  for i in inbox:
    inboxa.append(i)
  return inboxa
# Returns list. If no unread messages, list length will be 1. Otherwise, length is number of unread items - 1
 
def sent(username):
  """Returns list of sent entries. See below example"""
  apikey = check_login(username)['apikey']
  version = "IRC"
  inboxdata = urllib.urlencode({'mode': 'SENT', 'username': username, 'apikey': apikey, 'version': version})
  # The one special case
  inbox = urllib2.urlopen(url, inboxdata).read().split("\n")
  inboxa = []
  for i in inbox:
    inboxa.append(i)
  return inboxa
# Returns list. If no unread messages, list length will be 1. Otherwise, length is number of unread items - 1
 
def read(username):
  """Returns list of read entries. See below example"""
  apikey = check_login(username)['apikey']
  version = "IRC"
  inboxdata = urllib.urlencode({'mode': 'READ', 'username': username, 'apikey': apikey, 'version': version})
  # The one special case
  inbox = urllib2.urlopen(url, inboxdata).read().split("\n")
  inboxa = []
  for i in inbox:
    inboxa.append(i)
  return inboxa
# Returns list. If no unread messages, list length will be 1. Otherwise, length is number of unread items - 1
 
def exampleinboxusage(username):
  inboxls = inbox(username)
  if len(inboxls) > 1:
    for i in inboxls:
      i = json.loads(i)
      try:
        status = i['status']
        unread = i['unread']
        print "%s unread messages for %s:" % (unread, i['username'])
      except KeyError:
        id = i['id']
        to = i['to']
        fromuser = i['from']
        message = i['message']
        complex = i['complex']
        attachments = i['attachments']
        sentfrom = i['sentfrom']
        sendtime = i['sendTime']
        print "%s: %s - to %s from %s at %s (sent from %s)" % (id, message, to, fromuser, sendtime, sentfrom)
  else:
    for i in inboxls:
      i = json.loads(i)
      unread = i['unread']
      print "%s unread messages for %s." % (unread, i['username'])
 
def mark(username, id, read):
  """username: xmail username; id: inbox[n]['id']; read: Boolean. true = read, false = unread"""
  apikey = check_login(username)['apikey']
  markdata = urllib.urlencode({'mode': 'MARK', 'pid': id, 'uid': randrange(1, 1001), 'username': username, 'apikey': apikey, 'read': read, 'version': 'IRC'})
  mark = get_json(url, markdata)
  return mark
# Returns:
# {u'status': u'OK', u'message': u'Updated Message'}
 
def info():
  """Returns server info"""
  infodata = urllib.urlencode({'mode': 'INFO', 'version': 'IRC'})
  info = get_json(url, infodata)
  return info
# Returns:
# {u'status': u'OK', u'ip': u'IP address', u'version': u'XMAIL-1.1.1-OFFICIAL_SERVER', u'posturl': u'http://xmail.turt2live.com/mail', u'econaccount': u'@economy', u'message': u'xMail PHP Server', u'now': 1373012096}