#!/usr/bin/env python2.7
# This script gets usage from my ISP's website, checks to see if the current average for the month 
# is above their recommended amount per day, then disables the wifi on my router if it is.
# I made this for a household of people who don't understand the consequences of their actions
# (namely, that if you abuse our awesome internet, we all have to suffer with being shaped :( )
# Please, modify this for your own ISP/router and set it up in your own house to help with 
# your daily usage. -blha303
# BSD license.
username = "USERNAME"
password = "PASSWORD"
routerpass = "routerpass"
 
import urllib2
from BeautifulSoup import BeautifulSoup
import urllib
import cookielib
import time

def getnumbers(inp): # For parsing "100,000MB" to an integer
  return int(inp[:-2].replace(",", ""))

url = "https://myaccount2.westnet.com.au/" # login page url
# what the server sees as the client ID
desc = "westnet usage alert script by blha303. https://gist.github.com/blha303/5788199 for source"

logindata = urllib.urlencode({"hdnLoginType": "myaccount",  # login POST data
                              "action": "login", 
                              "username": username, 
                              "password": password})

cj = cookielib.CookieJar() # Cookie jar, used to store login session
opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(cj))
opener.addheaders = [('User-Agent', desc)] # set client ID to desc

login = opener.open(url, logindata) # log in, save session data to cookie jar
 
page  = opener.open(url) # reopen same url (westnet has both login and homepage on the same url)
soup  = BeautifulSoup(page.read()) # make soup from page
usage = soup.findAll('div',{'class':'usage_text'})[0].text # get usage string "XXX,XXXMB out of XXX,XXXMB"
count = getnumbers(usage.split(" ")[0]) # get count integer, first part of usage string above as integer
total = getnumbers(usage.split(" ")[-1]) # get total integer, last part of usage string above as integer
suggested = getnumbers(soup.findAll('a',{'href':'#suggested_anytime_tooltip'})[0].text) # get suggested integer
trend = getnumbers(soup.findAll('a',{'href':'#trend_anytime_tooltip'})[0].text) # get trend integer
#print "usage: " + usage
#print "count: " + str(count)
#print "total: " + str(total)
#print "suggested: " + str(suggested)
#print "trend: " + str(trend)

boblogin = "http://10.1.1.1/login.cgi" # router login url
# router login info as POST data
bobdata = urllib.urlencode({"login_option": "0", "password": routerpass, "passwordtemp": ""}) 
wdisurl = "http://10.1.1.1/wireless_id.wl?wlSsidIdx=0&wlEnbl=0" # router disable wireless url as GET data
wenurl = "http://10.1.1.1/wireless_id.wl?wlEnbl=1&wlSsidIdx=0" # router enable wireless url as GET data

ts = time.strftime("%a, %d %b %Y %H:%M:%S +0000", time.gmtime()) # timestamp for status webpage

def logintoBob():
  opener.open(boblogin, bobdata) # log into router, save session to cookie jar

def enableWireless(f):
  logintoBob()
  opener.open(wenurl) # send wireless enable request using login info from cookiejar
  f.write("%s: Enable wireless<br>" % ts)

def disableWireless(f):
  logintoBob()
  opener.open(wdisurl) # send wireless disable request using login info from cookiejar
  f.write("%s: Disable wireless<br>" % ts)

if count > total:
  shaped = True
else:
  shaped = False

#print "shaped: " + str(shaped)

f = open("/var/www/westnet.html", "a") # Append to web-accessible file
if trend > suggested and not shaped:
  disableWireless(f)
elif shaped or trend <= suggested:
  enableWireless(f)
f.close()
