from twisted.internet import reactor, task, defer, protocol
from twisted.python import log
from twisted.words.protocols import irc
from twisted.application import internet, service
import yaml, sys, random, re

with open(sys.argv[1] if len(sys.argv) > 1 else 'config.yml') as f:
    config = yaml.load(f.read())
HOST, PORT = config['host'], config['port']

class CAHPlayerProtocol(irc.IRCClient):
    nickname = config['nick']
    password = config['password'] if 'password' in config else None
    username = config['nick']
    versionName = "CAHPlayer"
    versionNum = "v0.0.1"
    realname = config['nick']
    cards = []
    need = 0
    phrase = ""
    czar = False
    choices = []

    def signedOn(self):
        for channel in self.factory.channels:
            self.join(channel)

    def noticed(self, user, channel, message):
        nick, _, host = user.partition('!')
        log.msg("NOTICE: {} <{}> {}".format(channel, nick, message))
        if nick == config["gamebot"]:
            if message[:2] == "1.":
                self.cards = re.split("\x02|\x0f", message)[1::2]
                picks = [random.choice(self.cards) for x in xrange(1,self.need+1)]
                nums = [str(self.cards.index(p)+1) for p in picks]
#                self.msg(self.factory.channels[0], self.phrase.format(*picks))
                self.msg(self.factory.channels[0], "!pick " + " ".join(nums))

    def privmsg(self, user, channel, message):
        if not channel in self.factory.channels:
            return
        nick, _, host = user.partition('!')
        log.msg("{} <{}> {}".format(channel, nick, message))
        split = message.strip().split(" ")
        if nick == config["gamebot"]:
            if "<BLANK>" in message:
                self.phrase = message.replace("<BLANK>", "{}").replace("\x02", "")
                self.need = message.count("<BLANK>")
            elif self.nickname[1:] in message and "is the card czar." in message:
                self.czar = True
            elif self.nickname[1:] in message and "is picking a winner" in message:
                self.czar = False
                log.msg(", ".join(self.choices))
                self.msg(channel, "!pick " + random.choice(self.choices).split(".")[0])
            elif self.czar:
                self.choices.append(message.replace("\x02", "").replace("\x0f", ""))
        if self.nickname in split[0]:
            if split[1].lower() == "say" and nick == "blha303":
                self.msg(channel, " ".join(split[2:]))
            if split[1].lower() == "join":
                self.msg(channel, "!join")
            if split[1].lower() == "stop":
                self.msg(channel, "!stop")
            

class CAHPlayerFactory(protocol.ReconnectingClientFactory):
    protocol = CAHPlayerProtocol
    channels = config["channels"]

if __name__ == '__main__':
    reactor.connectTCP(HOST, PORT, CAHPlayerFactory())
    log.startLogging(sys.stdout)
    reactor.run()

elif __name__ == '__builtin__':
    application = service.Application('CAHPlayer')
    ircService = internet.TCPClient(HOST, PORT, CAHPlayerFactory())
    ircService.setServiceParent(application)
