from selenium import webdriver
from selenium.webdriver.common.by import By
from selenium.webdriver.support.ui import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC
from selenium.webdriver.chrome.options import Options
from os import environ

try:
    driver = webdriver.Chrome("Downloads\\chromedriver.exe")

    driver.get("https://portal.afterpay.com/au/login-email")
    _wait = WebDriverWait(driver, 10)

    def wait(selector):
        return _wait.until(EC.visibility_of_element_located((By.CSS_SELECTOR, selector)))

    def wait_then_input(selector, inp):
        return _wait.until(EC.visibility_of_element_located((By.CSS_SELECTOR, selector))).send_keys(inp)

    wait_then_input("input[automation_id='input-email']", environ["AFTERPAY_EMAIL"])
    driver.find_elements_by_css_selector("button[automation_id='button-submit']")[0].click()

    wait_then_input("input[automation_id='input-password']", environ["AFTERPAY_PASSWORD"])
    driver.find_elements_by_class_name("checkbox__tick")[0].click()
    driver.find_elements_by_css_selector("button[automation_id='button-submit']")[0].click()
    wait(".orders-banner__panel")

    driver.get("https://portalapi.afterpay.com/portal/consumers/paymentschedule/due?ascending=true&limit=100&offset=0&orderBy=dueDate")

    with open("Downloads\\afterpay-due.json", "w") as f:
        f.write(driver.find_element_by_tag_name('pre').text)
finally:
    driver.quit()