# Usage: gethbdownloads.py > filelist.txt
# Then: wget --content-disposition --no-check-certificate -c -i filelist.txt
# Defaults to returning torrent urls, easily configurable

from __future__ import print_function
from sys import stderr, exit
from getpass import getpass
import humblebundle # https://pypi.python.org/pypi/humblebundle

ERRORS = {1: "Login failed, please check details"}

def query(prompt=None, default=None):
    if prompt:
        stderr.write(str(prompt))
    return raw_input() or default

def main():
    client = humblebundle.HumbleApi()
    if not client.login(query("humblebundle.com email: "), getpass("humblebundle.com password: ", stderr)):
        return 1
    platform = query("Platform [windows]: ", "windows")
    torrent = query("Bittorrent [true]: ", "true").lower()[0] in ['t', '1', 'y']
    with open("HB-{}.md5".format(platform), "w") as f:
        for order in [client.get_order(gamekey) for gamekey in client.get_gamekeys()]:
            if order and order.subproducts:
                for product in order.subproducts:
                    for dl in product.downloads:
                        if dl.platform == platform:
                            info = dl.download_struct[0]
                            f.write("{} *{}\n".format(info.md5, info.url.web.split("/")[-1].split("?")[0]))
                            if torrent and not info.url.bittorrent:
                                print("*** Url is not a torrent url: " + info.url.web, file=stderr)
                            print(info.url.bittorrent if torrent and info.url.bittorrent else info.url.web)

if __name__ == "__main__":
    retcode = main()
    if retcode in ERRORS:
        print(ERRORS[retcode], file=stderr)
    exit(retcode)