#!/usr/bin/env python
# input files:
# - hashlist.txt, a file containing the user hashes to check, in format username:hash, one per line.
#   (or change the input to whatever you need it as)
# - pwned-passwords-sha1-ordered-by-count-v4.txt, get this from https://haveibeenpwned.com/Passwords
#   any format is fine, just update the file name below
# the script will output percentage of the password file completed to stdout. compare this against your
# original password list, or modify the block at the end to further process the data
import os.path
inp_users = "hashlist.txt"
inp_passwords = "pwned-passwords-sha1-ordered-by-count-v4.txt"
with open(inp_users) as f:
    d = {hash:user for user,hash in (l.strip().split(":") for l in f.readlines())}

out = []
filesize = os.path.getsize(inp_passwords)
with open(inp_passwords) as f:
  t=0
  for line in f:
    if line.split(":")[0] in d:
      out.append(line)
    t+=len(line)
    print((t/filesize)*100,end="\r")

print("\n".join(out))