/** @param {NS} ns */
export async function main(ns) {
  const scripts = [
    {name: "/alain/stats.js", args:[]},
    {name: "/stockmaster.js", args:["--toastStyle", ""], tail:true},
    {name: "/pserv.js", args:[], tail:true},
    {name: "/local.js", args:[], tail:true},
    {name: "/alain/hacknet-upgrade-manager.js", args:["-c", "--reserve", "5000000000", "--time", "1000h", "--interval", "100"], tail:true},
  ];
    for(const {name,args,waitFor=false,tail=false} of scripts) {
        const pid = ns.run(name,1,...args);
        if(pid) {
            if (tail) {
              ns.tail(pid);
              await ns.sleep(0);
              ns.resizeTail(425, 203, pid);
            }
            ns.tprint(`Started ${name} with [${args}]`);
            if(waitFor) {
                ns.tprint("Waiting for it to exit...");
                await awaitByPid(ns,pid);
            }
        }
        else
            ns.tprint(`ERROR: Failed to start ${name} with ${args}!`);
        await ns.sleep(100);
    }
}