/** @param {NS} ns */
export async function main(ns) {
  const scripts = [
    {name: "/alain/stockmaster.js", args:["-l"]},
    {name: "/alain/kill-all-scripts.js", args:[]},
  ];
    for(const {name,args,waitFor=false} of scripts) {
        const pid = ns.run(name,1,...args);
        if(pid) {
            ns.tprint(`Started ${name} with [${args}]`);
            if(waitFor) {
                ns.tprint("Waiting for it to exit...");
                await awaitByPid(ns,pid);
            }
        }
        else
            ns.tprint(`ERROR: Failed to start ${name} with ${args}!`);
        await ns.sleep(100);
    }
}