import { targets } from "/targets.js";

export async function main(ns) {
    const args = ns.flags([['help', false]]);
    let hostname = args._[0];
    if(!hostname) {
        hostname = targets[Math.floor(Math.random()*targets.length)];
    }
    while (true) {
        if (ns.getServerSecurityLevel(hostname) > (ns.getServerMinSecurityLevel(hostname)+1)) {
            await ns.weaken(hostname);
        } else if (ns.getServerMoneyAvailable(hostname) < (ns.getServerMaxMoney(hostname)*0.75)) {
            await ns.grow(hostname);
        } else {
            await ns.hack(hostname);
        }
    }
}