from plexapi.server import PlexServer
import sys
plex = PlexServer()
now_playing = plex.query("/status/sessions")
if not now_playing:
    sys.exit(0)
sessions = []
for item in now_playing:
    data = {
        "title": item.attrib["title"],
        "user": item.find(".//User").attrib["title"],
        "product": ("on a " + item.find(".//Player").attrib["device"]) if
             item.find(".//Session").attrib["location"] == "cellular" else
             ("using " + item.find(".//Player").attrib["product"])
    }
    if item.tag == "Track":
        data.update({"artist": item.attrib["originalTitle"]})
        sessions.append("{user} is listening to {title} by {artist} {product}".format(**data))
    elif item.tag == "Video":
        data.update({"year": item.attrib["year"]})
        if "grandparentTitle" in item.attrib:
            data.update({"show": item.attrib["grandparentTitle"]})
            sessions.append("{user} is watching {show}: {title} {product}".format(**data))
        else:
            sessions.append("{user} is watching {title} ({year}) {product}".format(**data))
    else:
        continue
if len(sessions) > 2:
    print(", ".join(sessions[:-1]) + ", and " + sessions[-1])
else:
    print(", and ".join(sessions))