from plexapi.server import PlexServer
import sys
plex = PlexServer("http://172.16.17.10:32400")
now_playing = plex.query("/status/sessions")
if not now_playing:
    print("Nobody's watching anything")
    sys.exit(0)
sessions = []
def hms(mil):
    s,mil = divmod(int(mil), 1000)
    m,s = divmod(s, 60)
    h,m = divmod(m, 60)
    return h,m,s,mil
for item in now_playing:
    data = {
        "title": item.attrib["title"],
        "user": item.find(".//User").attrib["title"],
        "product": ("on a " + item.find(".//Player").attrib["device"]) if
             item.find(".//Session").attrib["location"] == "cellular" else
             ("using " + item.find(".//Player").attrib["product"]),
        "offset": "{}:{:02d}:{:02d}.{:03d}".format(*hms(item.attrib["viewOffset"]))
    }
    if item.tag == "Track":
        data.update({"artist": item.attrib["grandparentTitle"]})
        sessions.append("{user} is listening to {title} by {artist} {product} ({offset})".format(**data))
    elif item.tag == "Video":
        data.update({"year": item.attrib["year"]})
        if "grandparentTitle" in item.attrib:
            data.update({"show": item.attrib["grandparentTitle"]})
            sessions.append("{user} is watching {show}: {title} {product} ({offset})".format(**data))
        else:
            sessions.append("{user} is watching {title} ({year}) {product} ({offset})".format(**data))
    else:
        continue
if len(sessions) > 2:
    print(", ".join(sessions[:-1]) + ", and " + sessions[-1])
else:
    print(", and ".join(sessions))