# Check system uptime
$uptime = Get-Uptime
$uptimeDays = $uptime.TotalDays

# Check if uptime is greater than 7 days
if ($uptimeDays -gt 7) {
    Write-Host "System has been up for $($uptimeDays) days. Scheduling a reboot in 24 hours."

    # Schedule reboot in 24 hours
    $rebootTime = (Get-Date).AddHours(24)
    shutdown.exe /r /t 86400  # 86400 seconds = 24 hours
} else {
    Write-Host "System uptime is $($uptimeDays) days. No reboot scheduled."
}