$uptime = Get-Uptime
$uptimeDays = $uptime.TotalDays

if ($uptimeDays -gt 7) {
    $rebootTime = (Get-Date).AddHours(24)
    shutdown.exe /r /t 86400
}

$taskName = "uptime reboot"

if (!(Get-ScheduledTask -TaskName $taskName -ErrorAction SilentlyContinue)) {
    $action = New-ScheduledTaskAction -Execute "pwsh.exe" -Argument "-NoLogo -ExecutionPolicy Bypass -NoProfile -NonInteractive -File $(Resolve-Path $myinvocation.InvocationName)"
    $trigger = New-ScheduledTaskTrigger -Daily -At "8:00 AM"
    $task = Register-ScheduledTask -Action $action -Trigger $trigger -TaskName $taskName -Description "Check uptime; if >7 days, schedule reboot"
    if (Get-Command New-BurntToastNotification -ErrorAction SilentlyContinue) {
        New-BurntToastNotification -Text "uptime reboot task created for 8am daily"
    }
}