#!/usr/bin/env python3
from requests import post
from twitter import Api # pip install python-twitter
from json import load

lists = [("567697393169072140", "blha303", "reog")]

with open("twitter.json") as f:
    api = Api(**load(f))

with open(".bottoken") as f:
    token = f.read().strip()


def get_list_since(sn, slug, since):
    timeline = api.GetListTimeline(slug=slug, owner_screen_name=sn, since_id=since)
    return timeline, timeline[0].id if timeline else None

def post_to_discord(channel, text):
    """ Posts to Discord like a boss """
    if text is False:
        return "cool"
    print(text)
    d = post("https://discordapp.com/api/channels/{}/messages".format(channel),
             json={"content": text},
             headers={"Authorization": "Bot " + token,
                      "User-Agent": "twitter-discord-lists by suv"
                     }).json()
    return "cool"

if __name__ == "__main__":
    for channel, sn, slug in lists:
        try:
            with open(".{}{}since".format(sn, slug)) as f:
                since = f.read().strip()
        except:
            since = None
        timeline, since = get_list_since(since)
        if since:
            for t in timeline:
                post_to_discord(567697393169072140, "https://twitter.com/{}/status/{}".format(t.user.screen_name, t.id))
            with open(".{}{}since".format(sn, slug)) as f:
                f.write(str(since))
