<!-- /usr/share/icecast2/web/status.xsl -->
<xsl:stylesheet xmlns:xsl = "http://www.w3.org/1999/XSL/Transform" version = "1.0">
<xsl:output omit-xml-declaration="yes" method="xml" indent="yes" encoding="UTF-8" />
<xsl:template match = "/icestats">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
        <title>radio.aly.pet</title>
        <link rel="stylesheet" type="text/css" href="style.css" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=yes" />
</head>
<body>
        <h1 id="header">radio.aly.pet</h1>
        <!--index header menu
        <div id="menu">
                <ul>
                        <li><a href="admin/">Administration</a></li>
                        <li><a href="status.xsl">Server Status</a></li>
                        <li><a href="server_version.xsl">Version</a></li>
                </ul>
        </div>
        end index header menu -->
        <div id="container">
                <div id="details" style="display:flex;flex-wrap:wrap">
                        <img />
                        <div>
                                <span>
                                        Now playing:
                                        <a></a>
                                </span>
                                <ul style="display:flex;flex-direction:column">
                                        Recently played:
                                        <li><a></a></li>
                                        <li><a></a></li>
                                        <li><a></a></li>
                                        <li><a></a></li>
                                        <li><a></a></li>
                                </ul>
                        </div>
                </div>
                <audio style="width:90%" controls="" src="/stream" type="audio/mpeg" />
                <iframe id="iframe"></iframe>
        </div>
        <div id="footer">
                Support icecast development at <a href="https://www.icecast.org/">www.icecast.org</a>
        </div>
</body>
<script>
        var np;
        var iframe = document.getElementById("iframe");
        iframe.style.display = "none";
        iframe.style.width = "90%";
        iframe.style.minHeight = "550px";
        iframe.style.borderRadius = "10px";
        iframe.style.padding = "15px 20px";
        iframe.style.marginBottom = "35px";
        var img = document.querySelector("#details img");
        img.style.maxWidth = "350px";
        img.style.display = "none";
        var text = document.querySelector("#details div span");
        text.style.display = "none";
        var textA = document.querySelector("#details div span a");
        var ul = document.querySelector("#details div ul");
        function getData() {
                fetch("/recent.json").then(function(req){
                        req.json().then(function(data){
                                data = data.reverse()
                                var items = ul.querySelectorAll("li a")
                                for (const n of Array(data.length).keys()) {
                                        var a = items[n];
                                        if (data[n].guid.startsWith("plex://")) {
                                                a.setAttribute("href", "https://listen.plex.tv" + data[n].guid.substr(6));
                                        } else {
                                                a.setAttribute("href", data[n].url);
                                        }
                                        a.innerHTML = data[n].artist + " - " + data[n].title;
                                }
                        });
                });
                fetch("/np.json").then(function(req){
                        req.json().then(function(data){
                                np = data;
                                if (iframe.src.endsWith(np["@parentGuid"].substr(6))) return;
                                if (!np["@parentGuid"].startsWith("plex://")) {
                                        iframe.style.display = "none";
                                        textA.href = np["Media"]["Part"]["@key"];
                                } else {
                                        iframe.setAttribute("src", "https://listen.plex.tv" + np["@parentGuid"].substr(6));
                                        iframe.style.display = "block";
                                        textA.href = "https://listen.plex.tv" + np["@parentGuid"].substr(6);
                                }
                                img.setAttribute("src", np["@thumb"]);
                                img.style.display = "block";
                                textA.innerText = np['@grandparentTitle'] + " - " + np['@title'] + " (" + np['@parentTitle'] + ")";
                                text.style.display = "block";
                        })
                });
                setTimeout(getData,5000);
        }
        getData();
</script>
</html>
</xsl:template>
</xsl:stylesheet>