#!/usr/bin/env python3
from plexapi.myplex import MyPlexAccount
from plexapi.server import PlexServer
from dotenv import load_dotenv
import xmltodict as xtd
load_dotenv()
from os import environ
from xml.etree import ElementTree
from json import dumps, dump
from time import sleep
out = ""
account = MyPlexAccount(environ["PLEX_USER"], environ["PLEX_PASSWORD"])
token = account.resource(environ["PLEX_SERVER_NAME"]).accessToken
laptop = PlexServer(environ["PLEX_SERVER_ADDR"], token)
prev = {"@guid": None}
recent = []
while True:
    try:
        p = [p for p in laptop.sessions() if p.player.title == "l"][0]
        xml = xtd.parse(ElementTree.tostring(p._data,encoding="utf-8"))["Track"]
        if xml["@guid"] == prev["@guid"]:
            sleep(15)
            continue
        recent.append({"url": xml["Media"]["Part"]["@key"], "guid": xml["@guid"], "artist": xml["@grandparentTitle"], "title": xml["@title"]})
        if len(recent) > 5:
            recent = recent[1:]
        with open("/usr/share/icecast2/web/recent.json", "w") as f:
            dump(recent,f)
        prev = xml
        del xml["Player"]
        del xml["User"]
        out = xml
    except Exception as e:
        out = {"error": str(e)}
    out = dumps(out,indent=4)
    print(out)
    with open("/usr/share/icecast2/web/np.json", "w") as f:
        f.write(out)
    sleep(15)