#!/usr/bin/env python3

import gmusicapi
import os
from argparse import ArgumentParser
import requests
from mutagen import File

gmusic = gmusicapi.Mobileclient()
gmusic.login(os.environ["GMUSICAPI_EMAIL"], os.environ["GMUSICAPI_PASSWORD"], os.environ["GMUSICAPI_MACADDR"])

def get_track(track_id):
    track = gmusic.get_track_info(track_id)
    try:
        os.makedirs(os.path.join(track["artist"], track["album"]))
    except:
        pass
    fn = os.path.join(track["artist"], track["album"], "{trackNumber:0>2} {artist} - {title}.mp3".format(**track).replace("/", "-"))
    print(fn, end="")
    with open(fn, "wb") as f:
        f.write(requests.get(gmusic.get_stream_url(track["storeId"])).content)
    f = File(fn, easy=True)
    for x in ["title", "artist", "album", "trackNumber"]:
        if track[x]:
            f[x.lower()] = str(track[x]).zfill(2)
    f.save()
    print("\r" + fn + " done")

def get_album(album_id):
    album = gmusic.get_album_info(album_id, include_tracks=True)
    return album

def get_artist(artist_id):
    artist = gmusic.get_artist_info(artist_id, include_albums=True)
    return artist

def main():
    parser = ArgumentParser()
    parser.add_argument("id", nargs="+")
    args = parser.parse_args()
    to_get = []
    for _id in args.id:
        if _id[0] == "A":
            artist = get_artist(_id)
            for album in artist["albums"]:
                album = get_album(album["albumId"])
                for track in album["tracks"]:
                    to_get.append(track["storeId"])
        elif _id[0] == "B":
            album = get_album(_id)
            for track in album["tracks"]:
                to_get.append(track["storeId"])
        elif _id[0] == "T":
            to_get.append(_id)
    print("Queued {} items".format(len(to_get)))
    for trid in to_get:
        get_track(trid)
    return 0

if __name__ == "__main__":
    import sys
    sys.exit(main())