#!/usr/bin/env python3

import gmusicapi
import os
from argparse import ArgumentParser
import requests
from mutagen import File

gmusic = gmusicapi.Mobileclient()
gmusic.login(os.environ["GMUSICAPI_EMAIL"], os.environ["GMUSICAPI_PASSWORD"], os.environ["GMUSICAPI_MACADDR"])

def get_album(album_id):
    album = gmusic.get_album_info(album_id, include_tracks=True)
    try:
        os.makedirs(os.path.join(album["artist"], album["name"]))
    except:
        pass
    for track in album["tracks"]:
        fn = os.path.join(track["artist"], track["album"], "{trackNumber:0>2} {artist} - {title}.mp3".format(**track).replace("/", "-"))
        print(fn)
        with open(fn, "wb") as f:
            f.write(requests.get(gmusic.get_stream_url(track["storeId"])).content)
        f = File(fn, easy=True)
        for x in ["title", "artist", "album", "trackNumber"]:
            if track[x]:
                f[x.lower()] = str(track[x]).zfill(2)
        f.save()
    return os.path.join(album["artist"], album["name"])

def main():
    parser = ArgumentParser()
    parser.add_argument("albumid", nargs="+")
    args = parser.parse_args()
    for album_id in args.albumid:
        print(get_album(album_id))
    return 0

if __name__ == "__main__":
    import sys
    sys.exit(main())