#!/usr/bin/env python3
import requests
from sys import stderr, stdout, argv
from os import environ

host = environ.get("PLEX_HOST", "")
token = environ.get("PLEX_TOKEN", "")

args = argv[1:]

def prompt(text):
    global args
    print(text, file=stderr, end="")
    if args:
        picked = args.pop(0)
        print(picked, file=stderr)
        return picked
    return input()

def get(endpoint):
    url = host + ("/" if endpoint[0] != "/" else "") + endpoint
    r = requests.get(url, params={"X-Plex-Token": token}, headers={"Accept": "application/json"})
    return r.json()

def main():
    libraries = [d for d in get("/library/sections")["MediaContainer"]["Directory"]]
    for n,l in enumerate(libraries):
        print(f"[{l['key']}] {l['title']}", file=stderr)
    choice = prompt("Pick library: ")
    library = [l for l in libraries if l["key"] == choice][0]
    lib_list = [i for i in get(f"/library/sections/{library['key']}/all")["MediaContainer"]["Metadata"]]
    for n,i in enumerate(lib_list):
        print(f"[{n}] {i['title']}", file=stderr)
    picked = lib_list[int(prompt("Pick item: "))]
    if picked["type"] == "show":
        episodes = [e for e in get(picked["key"].replace("children", "allLeaves"))["MediaContainer"]["Metadata"]]
        for n,e in enumerate(episodes):
            print(f"[{n}] S{e['parentIndex']:02d}E{e['index']:02d} {e['title']}", file=stderr)
        picked = episodes[int(prompt("Pick episode: "))]
    print(f"{host}{picked['Media'][0]['Part'][0]['key']}?X-Plex-Token={token}")
    return 0

if __name__ == "__main__":
    from sys import exit
    exit(main())