#!/usr/bin/env python3
# usage: fedipost.py jsonfeed_url webhook_url [filter_text]
# e.g: fedipost.py https://blahaj.zone/@alypet.json webhook #alyblog
from markdownify import markdownify
from requests import get,post
import os, sys

WH = sys.argv[2]

try:
    with open("posts.txt") as f:
        posts = f.read().strip().split("\n")
except:
    posts = []

feed = get(sys.argv[1]).json()
items = []
for item in feed["items"]:
    if item["url"] in posts:
        continue
    content = item["content_html"].split('<span class="new_note')[0].split(" <span class=\"reply_note")[0]
    if len(sys.argv) > 3:
        if sys.argv[3] not in content:
            continue
    img = {"image": {"url": ""}}
    if "<img" in content:
        content, img_url = content.split("<img",1)
        img["image"]["url"] = img_url.split(' src="',1)[1].split('"')[0]
    content = markdownify(content).strip()
    data = {
        "username": "Fediverse",
        "avatar_url": feed["icon"],
        "embeds": [
            {
                "title": feed["title"],
                "url": feed["home_page_url"],
                "color": 16711829,
                "fields": [
                    {
                        "name": "New post",
                        "value": content[:1020] + ("..." if len(content) > 1020 else "")
                    }
                ],
                "url": item["url"],
                "timestamp": item["date_modified"][:-5] + "Z",
                **img
            }
        ]
    }
    post(WH, json=data)
    posts.append(item["url"])
    with open("posts.txt", "w") as f:
        f.write("\n".join(posts))