#!/usr/bin/env python3
# usage: fedipost.py jsonfeed_url webhook_url [filter_text]
# e.g: fedipost.py https://blahaj.zone/@alypet.json webhook #alyblog
from markdownify import markdownify
from requests import get,post
import os, sys

WH = sys.argv[2]

try:
    with open("posts.txt") as f:
        posts = f.read().strip().split("\n")
except:
    posts = []

feed = get(sys.argv[1]).json()
items = []
for item in feed["items"]:
    if item["url"] in posts:
        continue
    if len(sys.argv) > 3:
        if sys.argv[3] not in item["content_html"]:
            continue
    content = markdownify(item["content_html"]).strip()
    data = {
        "username": "Fediverse",
        "avatar_url": feed["icon"],
        "embeds": [
            {
                "title": feed["title"],
                "url": feed["home_page_url"],
                "color": 16711829,
                "fields": [
                    {
                        "name": "\u200B",
                        "value": content
                    }
                ],
                "url": item["url"],
                "timestamp": item["date_modified"][:-5] + "Z"
            }
        ]
    }
    post(WH, json=data)
    posts.append(item["url"])
    with open("posts.txt", "w") as f:
        f.write("\n".join(posts))