from pypresence import Presence # https://github.com/qwertyquerty/pypresence
from flask import *
from requests import get
from time import sleep

client_id = "556918123421368329"

RPC = Presence(client_id)
RPC.connect()
app = Flask(__name__)

def update_status(text, d=""):
    RPC.update(state=text, details=d if d else None, large_image="desk")
    return redirect(url_for("index"))

@app.route("/_calls")
def r_calls():
    return update_status("Answering calls")

@app.route("/_tickets")
def r_tickets():
    return update_status("Answering tickets")

@app.route("/_dev")
def r_dev():
    return update_status("some software for once", "Actually developing")

@app.route("/_chatting_to_coworkers")
def r_chat():
    return update_status("Putting out fires")

@app.route("/_lunch")
def r_lunch():
    return update_status("Out to lunch")

@app.route("/_clear")
def r_clear():
    RPC.clear()
    return redirect(url_for("index"))

@app.route("/")
def index():
    return """
<a href="/_calls">Answering calls</a><br>
<a href="/_tickets">Answering tickets</a><br>
<a href="/_dev">Actually developing some software for once</a><br>
<a href="/_chatting_to_coworkers">Chatting</a><br>
<a href="/_lunch">Lunch</a><br>
<a href="/_clear">Clear</a><br>"""

app.run(port=8081,host="0.0.0.0")