#!/usr/bin/env python
import requests # pip install requests, apt install python-requests
from time import time
from argparse import ArgumentParser
from sys import exit

headers = {"Referer": "https://www.nbnco.com.au/"}

parser = ArgumentParser()
parser.add_argument("address", nargs="*")
parser.add_argument("--opts", help="e.g addressDetail.techType,location.id,servingArea.serviceStatus")
args = parser.parse_args()
locations = requests.get("https://places.nbnco.net.au/places/v1/autocomplete", params={"query": args.address, "timestamp": int(time()*1000)}, headers=headers).json()
for n,location in enumerate(locations["suggestions"]):
    print("{}: {}".format(n,location["formattedAddress"]))
if len(locations["suggestions"]) != 1:
    try:
        choice = raw_input("Pick a number> ")
    except NameError:
        choice = input("Pick a number> ")
else:
    choice = 0
location = locations["suggestions"][int(choice)]

nbninfo = requests.get("https://places.nbnco.net.au/places/v1/details/{}".format(location["id"]), headers=headers).json()
if args.opts:
    info = {}
    for opt in args.opts.split(","):
        _opt = opt
        while "." in opt:
            c,opt = opt.split(".",1)
            current = nbninfo[c]
        info[_opt] = current[opt]
    nbninfo = info
for k,v in nbninfo.items():
    if type(v) is dict:
        print("{}: {}".format(k,"\n\t".join("{}: {}".format(m,f) for m,f in v.items())))
    else:
        print("{}: {}".format(k,v))