#!/usr/bin/env python
import requests # pip install requests, apt install python-requests
from time import time
from argparse import ArgumentParser

headers = {"Referer": "https://www.nbnco.com.au/"}

parser = ArgumentParser()
parser.add_argument("address", nargs="*")
args = parser.parse_args()
locations = requests.get("https://places.nbnco.net.au/places/v1/autocomplete", params={"query": args.address, "timestamp": int(time()*1000)}, headers=headers).json()
for n,location in enumerate(locations["suggestions"]):
    print("{}: {}".format(n,location["formattedAddress"]))
if len(locations["suggestions"]) != 1:
    try:
        choice = raw_input("Pick a number> ")
    except NameError:
        choice = input("Pick a number> ")
else:
    choice = 0
location = locations["suggestions"][int(choice)]

nbninfo = requests.get("https://places.nbnco.net.au/places/v1/details/{}".format(location["id"]), headers=headers).json()
for k,v in nbninfo.items():
    if type(v) is dict:
        print("{}: {}".format(k,"\n\t".join("{}: {}".format(m,f) for m,f in v.items())))
    else:
        print("{}: {}".format(k,v))