#!/usr/bin/env python3
import requests
from datetime import datetime, timedelta

t = '\u2705'
f = '\u274c'
up = True

class Channel:
    category = ("1063529720538484786", "status")
    login = ("1063529561486270494", "status")

def get(*args, **kwargs):
    if "headers" not in kwargs:
        kwargs["headers"] = {}
    kwargs["headers"]["Authorization"] = f"Bot {token}"
    return requests.get(*args, **kwargs)

def patch(*args, **kwargs):
    if "headers" not in kwargs:
        kwargs["headers"] = {}
    kwargs["headers"]["Authorization"] = f"Bot {token}"
    return requests.patch(*args, **kwargs)

def update_channel_name(channel, status):
    channel_id, name = channel
    return patch("https://discord.com/api/channels/{}".format(channel_id), json={"name": status})

def a(obj):
    if not isinstance(obj, bool) and str(obj.status_code)[0] != "2":
        print(obj.headers)
        print(obj.json())

def is_up(status):
    return status in [1,2]

data = requests.get("https://is.xivup.com/indexdata").json()
up_data = [
        is_up(data["Realms"]["LoginzServer"]["Status"]),
        is_up(data["Realms"]["GatezServer"]["Status"]),
        is_up(data["DCs"]["Materia"]),
        is_up(data["Realms"]["Sophia"]["Status"])
]

if all(up_data):
    a(update_channel_name(Channel.login, f"status{t}"))
else:
    up = False
    a(update_channel_name(Channel.login, f"status" + "".join((t if _ else f) for _ in up_data)))

time = datetime.now().strftime("%H:%M")
eorzea = datetime.utcfromtimestamp(datetime.now().timestamp()*20.571428571428573).strftime("%H:%M")
a(patch("https://discord.com/api/channels/{}".format(Channel.category[0]), json={"name": (f"{f}-" if not up else "")+ f"status-{time}-AEST-{eorzea}-ET"}))