#!/usr/bin/env python3
import requests,json

page = requests.get("http://www.wowhead.com/world-quests/na").text
datasets,worldquest_raw = page.split("});\n\n//]]>")[0].split("\nvar lvWorldQuests")
datasets = [n.strip() for n in datasets.split("var _ = {};")][1:]
worldquests = json.loads(worldquest_raw.split("parent: 'list', data: ",1)[1].split("});\n\n//]]>",1)[0])

wq_items, wq_quests, wq_factions = {},{},{}
wq_types = {1: "Profession Quest", 2: "World Quest", 3: "PVP World Quest", 4: "Pet Battle", 5: "Emissary (Faction) Quest", 6: "Dungeon World Quest", 7: "?? Maybe world boss", 8: "Raid World Quest"}

for item in datasets[0].split(";")[:-3]:
    wq_items[int(item.split("_[",1)[1].split("]={",1)[0])] = json.loads(item.split("]=",1)[1])

for quest in datasets[1].split(";")[:-3]:
    wq_quests[int(quest.split("_[",1)[1].split("]={",1)[0])] = json.loads(quest.split("]=",1)[1])

for faction in datasets[3].split(";")[:-3]:
    wq_factions[int(faction.split("_[",1)[1].split("]={",1)[0])] = json.loads(faction.split("]=",1)[1])

for wq in worldquests:
    for n,f in enumerate(wq["factions"]):
        if f in wq_factions:
            wq["factions"][n] = {"id": f, "data": wq_factions[f]}
    if wq["rewards"]:
        if "items" in wq["rewards"]:
            for item in wq["rewards"]["items"]:
                if item["id"] in wq_items:
                    item["data"] = wq_items[item["id"]]
    if wq["worldquesttype"] in wq_types:
        wq["worldquesttype"] = {"id": wq["worldquesttype"], "label": wq_types[wq["worldquesttype"]]}
    wq["data"] = wq_quests[wq["id"]]

print(json.dumps(worldquests,indent=4))