Bandersnatch Maker
==================

This is a program I wrote on a live stream on the 14th (and 15th) of June 2019. https://www.twitch.tv/videos/438871676

You'll need some things.

* The movie (complete, with all clips, should be 05:12:14). See https://mehotkhan.github.io/BandersnatchInteractive/ for info on that.
* Some data from BandersnatchInteractive.
  * https://mehotkhan.github.io/BandersnatchInteractive/assets/bandersnatch.js 
  * https://mehotkhan.github.io/BandersnatchInteractive/assets/SegmentMap.js
* ffmpeg

You'll need to edit the two js files to remove `bandersnatch=` and `SegmentMap=` respectively so they parse as valid json. If you
encounter an error about utf-8 bom use dos2unix to fix it. Rename the files to `bandersnatch.json` and `SegmentMap.json`.

Open a python interpreter in the same directory as SegmentMap.js. I'd probably recommend 3.7. Paste this in:

```python
import json

with open("SegmentMap.json") as f:
  smap = json.load(f)

def msToTS(ms):
  s,ms = divmod(ms,1000)
  m,s = divmod(s,60)
  h,m = divmod(m,60)
  return "{:02d}:{:02d}:{:02d}.{:03d}".format(h,m,s,ms)

for segment in smap.values():
  ss = ""
  t = ""
  # working around ffmpeg seek to previous keyframe
  if segment["startTimeMs"] > 5000:
    # 40ms subtracted to account for one frame difference in 25fps source video
    ss = " -ss " + msToTS(segment["startTimeMs"]-4960)
  if "endTimeMs" in segment:
    t = " -t {}".format((segment["endTimeMs"]-segment["startTimeMs"])/1000)
  print("""ffmpeg{} -i bandersnatch.mkv -ss 5{} {}.mkv 2>/dev/null""".format(ss, t, segment))
```

You'll get a bunch of lines to run to generate clips from the full movie. I'd suggest putting these lines into a bash script 
and leaving it to run for a while in screen or tmux. This will take a very long time dependent on your CPU.

While that's going, generate some movies! 

```bash
$ python bandersnatch.py > concat.txt
picked 1A
out=['1E']
out=['1D']
poss=['1E', '1D']
picked 1D
out=['1H']
out=['1G']
poss=['1H', '1G']
picked 1G
...
out=['8JA']
out=['8JB1']
poss=['8JA', '8JB1']
picked 8JA
out=['0Cr4', '0cr3']
out=['0Cr4', '0cr3']
poss=['0Cr4', '0cr3']
picked 0Cr4 and added IDNT
01:04:02.610
```

The stderr output displays what choices were possible at each stage, which segment it picked, and the total length of the movie.

The output file concat.txt is produced in ffmpeg concat format, render it in the same directory as the segment files (e.g IDNT.mkv) with:

```bash
ffmpeg -f concat -i concat.txt -c copy `date +%Y%m%d-%H%M%S.mkv`
```