Bandersnatch Maker
==================

This is a program I wrote on a live stream on the 14th (and 15th) of June 2019. Video link coming soon.

You'll need some things.

* The movie (complete, with all clips, should be 05:12:14). See https://mehotkhan.github.io/BandersnatchInteractive/ for info on that.
* Some data from BandersnatchInteractive.
  * https://mehotkhan.github.io/BandersnatchInteractive/assets/bandersnatch.js 
  * https://mehotkhan.github.io/BandersnatchInteractive/assets/SegmentMap.js
* ffmpeg

You'll need to edit the two js files to remove `bandersnatch=` and `SegmentMap=` respectively so they parse as valid json. If you
encounter an error about utf-8 bom use dos2unix to fix it. Rename the files to `bandersnatch.json` and `SegmentMap.json`.

Open a python interpreter in the same directory as SegmentMap.js. I'd probably recommend 3.7. Paste this in:

```python
import json

with open("SegmentMap.json") as f:
  smap = json.load(f)

def msToTS(ms):
  s,ms = divmod(ms,1000)
  m,s = divmod(s,60)
  h,m = divmod(m,60)
  return "{:02d}:{:02d}:{:02d}.{:03d}".format(h,m,s,ms)

for segment in smap.values():
  ss = ""
  t = ""
  if segment["startTimeMs"] > 5000:
    ss = " -ss " + msToTS(segment["startTimeMs"]-5000)
  if "endTimeMs" in segment:
    t = " -t {}".format((segment["endTimeMs"]-segment["startTimeMs"])/1000)
  print("""ffmpeg{} -i bandersnatch.mkv -ss 5{} {}.mkv 2>/dev/null""".format(ss, t, segment["segment"]))
```

You'll get a bunch of lines to run to generate clips from the full movie. I'd suggest putting these lines into a bash script 
and leaving it to run for a while. This will take a very long time.

While that's going, generate some movies! They're produced in ffmpeg concat format, render them with:

```bash
ffmpeg -f concat -i FILENAME.txt -c copy `date +%Y%m%d-%H%M%S.mkv`
```