-- Uses FastJobSwitcher
jobs = {
  { name="PLD", xp=1  },
  { name="WAR", xp=2  },
  { name="DRK", xp=21 },
  { name="GNB", xp=26 },
  { name="MNK", xp=0  },
  { name="DRG", xp=4  },
  { name="NIN", xp=19 },
  { name="SAM", xp=23 },
  { name="RPR", xp=28 },
  { name="VPR", xp=30 },
  { name="WHM", xp=6  },
  { name="SCH", xp=18 },
  { name="AST", xp=22 },
  { name="SGE", xp=29 },
  { name="BRD", xp=3  },
  { name="MCH", xp=20 },
  { name="DNC", xp=27 },
  { name="BLM", xp=5  },
  { name="SMN", xp=18 },
  { name="RDM", xp=24 },
  { name="PCT", xp=31 }
}
lowest = { name="NONE", level=999, xp=-1 }
for _, job in ipairs(jobs) do
  CurrentLevel = GetLevel(job.xp)
  job.level = CurrentLevel
  LogDebug(job.name .. ": " .. job.level)
  if lowest.level > job.level then
    LogDebug(job.name .. " (" .. job.level .. ") lower than " .. lowest.name .. " (" .. lowest.level .. ")")
    lowest = job
  end
end
yield("/echo Switching to " .. lowest.name .. " (" .. lowest.level .. ")")
if lowest.name ~= "NONE" then
  yield("/" .. lowest.name)
end