#!/usr/bin/env python3
from requests import Session, get, post
from bs4 import BeautifulSoup as Soup

# Config
webhook = "" # discord webhook

shop = {
    # add entries for things you want to track
    # copy the numeric IDs from urls
    # e.g:
    # https://www.coles.com.au/product/monster-ultra-rosa-multipack-cans-4-x-500ml-4-pack-3990033 => 3990033
    # the fields are (coles, woolies, iga)
    "coke": ("2993706", "623034", "848631"),
    "monster": ("3990033", "143253", None),
}
# end Config

class Price:
    def __init__(self, coles, woolies, iga):
        self.coles = coles
        self.woolies = woolies
        self.iga = iga

    def sorted(self):
        price = {}
        if self.coles:
            price["coles"] = self.coles
        if self.woolies:
            price["woolies"] = self.woolies
        if self.iga:
            price["iga"] = self.iga
        return "\n".join(f"{name}: ${price:.2f}" for name,price in sorted(price.items(), key=lambda x: x[1]))

out = {}

for name,ids in shop.items():
    coles,woolies,iga = None,None,None
    if ids[0]:
        coles = Soup(get(f"https://www.coles.com.au/product/{ids[0]}").text, "html.parser")
    if ids[2]:
        iga = get(f"https://www.igashop.com.au/api/storefront/stores/84996/products/{ids[2]}").json()

    if ids[1]:
        session = Session()
        session.headers["User-Agent"] = 'Mozilla/5.0 (Windows NT 10.0; rv:109.0) Gecko/20100101 Firefox/116.0'
        session.get(f"https://www.woolworths.com.au/shop/productdetails/{ids[1]}")
        woolies = session.get(f"https://www.woolworths.com.au/api/v3/ui/schemaorg/product/{ids[1]}").json()

    out[name] = Price(
        float(coles.findAll("span", class_="price__value")[0].text[1:]) if coles else 0.0,
        woolies["offers"]["price"] if woolies else 0.0,
        float(iga["price"][1:]) if iga else 0.0
    )

post(webhook, json={"content": "\n\n".join(f"**{name}**\n{price.sorted()}" for name,price in out.items())})