import requests,time,socket,json,sys

def init_settings():
    try:
        with open("settings.json") as f:
            settings = json.load(f)
        return settings
    except:
        with open("settings.json", "w") as f:
            settings = dict(domain="REPLACE_WITH_DOMAIN",
                            host="REPLACE_WITH_SUBDOMAIN",
                            password="REPLACE_WITH_DDNS_PASSWORD",
                            updateUrl="https://dynamicdns.park-your-domain.com/update")
            f.write(json.dumps(settings))
        return False

def do_update(settings):
    with open("ddns.log", "a") as f:
        settings["ip"] = requests.get("http://ipv4.icanhazip.com").text.strip()
        oldip = socket.gethostbyname("{host}.{domain}".format(**settings))
        if settings["ip"] != oldip:
            d = requests.get(settings.pop("updateUrl"), params=settings).text
            if "<Done>true</Done>" in d:
                logline = "{}: Success ({})\r\n".format(time.ctime(), settings["ip"])
                retval = 0
            else:
                logline = "{}: Error: {} ({})\r\n".format(time.ctime(), d, settings["ip"])
                retval = 1
        else:
            logline = "{}: Skipping ({})\r\n".format(time.ctime(), settings["ip"])
            retval = 5
        f.write(logline)
        print logline.strip()
        return retval

def main():
    settings = init_settings()
    if settings:
        return do_update(settings)
    else:
        print "settings.json updated with url parameters, please update to fit the url provided by your DDNS service"
        return 50

if __name__ == "__main__":
    sys.exit(main())