from twisted.words.protocols import irc
from twisted.internet import protocol, task, reactor
from twisted.application import internet, service
import subprocess

nick = "Nexus"
user = "Nexus"
pass = "bouncer password"
jenkins_nick = "HawkJenkins"
jenkins_job = "Nexus"
script_path = "/home/nexus/redeploy.sh"

channel = "#DSH105" # channel script will try to join
server = "bouncer.bounce" # irc server or bouncer
port = 5555 # if changed, else 6667

class Bot(irc.IRCClient):
    nickname = nick
    username = user
    password = pass

    def signedOn(self):
        print "Signed on as %s." % self.nickname

    def privmsg(self, user, channel, msg):
        nick, _, host = user.partition("!")
        trigger_phrase = "Project %s build" % jenkins_job
        if nick == jenkins_nick and trigger_phrase in msg and "SUCCESS" in msg:
            out = subprocess.check_output([script_path])
            self.msg(channel, "Starting redeploy (triggered by %s)... " % jenkins_nick + out)

class BotFactory(protocol.ClientFactory):
    protocol = Bot

    def __init__(self, channel):
        self.channel = channel

    def clientConnectionLost(self, connector, reason):
        print "Lost connection (%s), reconnecting." % (reason,)
        connector.connect()

    def clientConnectionFailed(self, connector, reason):
        print "Could not connect: %s" % (reason,)

if __name__ == "__main__":
    channel = channel
    reactor.connectTCP(server, port, BotFactory(channel))
    reactor.run()
elif __name__ == '__builtin__':
    application = service.Application('H365IRCBot')
    channel = channel
    ircService = internet.TCPClient(server, port, BotFactory(channel))
    ircService.setServiceParent(application)
