#!/usr/bin/env python3
from json import load

with open("/tmp/lisserviceinfo.json") as f: # from os_GetServiceInfo
  d = load(f)["d"]

f = d["Metadata"]["Schemas"][0]["EntityContainers"][0]["FunctionImports"]

funcs = {}
for func in f:
  if not func["AuthPolicy"] in funcs:
    funcs[func["AuthPolicy"]] = []
  funcs[func["AuthPolicy"]].append(func)

def format(func):
  out = "* `/game/{Name}`\n".format(**func)
  if "Parameters" in func:
    func["params"] = ["`{Name}`, {Type}".format(**p) for p in func["Parameters"]]
    out += "   * Query params: " + "; ".join(func["params"]) + "\n"
  if func["HttpMethod"] != "GET":
    out += "   * {HttpMethod} request\n".format(**func)
  if "ReturnType" in func:
    out += "   * Returns {ReturnType}".format(**func)
  else:
    out += "   * Returns nothing"
  return out

for authpolicy, functions in funcs.items():
  print("\n### {}".format(authpolicy))
  for f in functions:
    try:
      print(format(f))
    except:
      print(f)
      raise
