### On game start

The game sends several requests in the opening videos. In the below documentation, text in curly braces (\{\}) is shorthand for `{ "d": {"os_Ping": ... } }` where os_Ping is the current endpoint being accessed and ... is the contents of the curly braces.

Necessary headers for each request (may vary, untested):

 * `Accept: application/json`, otherwise the API returns XML (obviously if you're fine with that you can omit this)
 * `OS-AuthProvider: 6`, unsure of the purpose of this
 * `OS-AuthTicketData: [string]`, begins with CAEQ on my copy of the game, unsure if variable
 * `OS-AuthTicketSize: 44`, not the length of the above auth ticket as the initial ticket is much longer
 * `OS-UID: [string]`, steam user ID, or some other form of identification in standalone versions probably
 * `OS-Platform: steam`, the user's platform, needs more testing to get options
 * `OS-System: linux`, ditto

1. `/game/os_Ping`
   * Likely confirming that the service is up, needs to succeed otherwise the game marks itself as offline
   * Returns `{ 6739 }`, different number each time

2. `/game/os_GetServiceInfo`
   * This returns information about the IP address used for connection: city name, country code, ip, lat, long, phone region code, zip code if available. Also returns a list of metadata, e.g client config and list of endpoints. Example output [here](https://gist.github.com/blha303/8c5b925f95c23c08197ac3a82e1bee15).

3. `/game/os_Ping` again

4. `/game/SEM_Login`
   * Probably for the Square Enix account login
   * Query params: `s_type` is 'UID' here; `s_value` is my steam user ID, a long string of digits
   * Returns `{ "__metadata": { "type": "game.SEMSubmit" }, "b_confirmed": true, "s_SEMID": "string of numbers", "s_email": "email address", "s_facebookID": "probably facebook user identifier", "s_longTermToken": "string of numbers and letters" }`

5. It sends the above request twice, unclear why

6. `/game/CreateUserProfile`
   * Square Enix login again? Probably making sure that there's an account for the given steam ID for stats collection even if it isn't linked to a SEM account
   * Query params: `s_uid` is my steam user ID
   * Returns `{ true }`

7. `/game/GetTodaysInfocast`
   * Returns a list of messages to be scrolled at the bottom of the main menu
   * Query params: `b_digital`, a boolean, probably whether it's digital or a physical disc; `i16_episode`, the episode number of the current save game; `s_locale`, language code e.g 'en'
   * Example response: https://gist.github.com/blha303/d00b1c34728cc21101b7fc198bbf3371

### On opening the choices menu item

1. `/game/CommunityFactsGetEpisode`
   * Returns a list of choices for a given episode, and the percentage and raw numbers for each choice
   * Query params: `i16_episode`, the given episode number
   * Example response for episode 1: https://gist.github.com/blha303/cec90d1d2e351c33d39ddddd880cd252

2. `/game/GetFriendsProfileStats`
   * Apparently would return the same as `/game/CommunityFactsGetEpisode` with additional info on friend stats, but currently returns nothing
   * Query params: `i16_episode`, the given episode number; `s_uid`, the steam/other user id
   * Currently returns `{ "d": {"results": [] } }`
