## Contents

* [Docs](https://gist.github.com/blha303/101e0db0bf63ea07b1f55862947c9065#file-docs-md)
* [Setting up capture process](https://gist.github.com/blha303/101e0db0bf63ea07b1f55862947c9065#file-revlis-md)
* [Automatically generated API documentation (inaccurate)](https://gist.github.com/blha303/101e0db0bf63ea07b1f55862947c9065#file-zgenerateddocs-md)
* [Script to generate API documentation](https://gist.github.com/blha303/101e0db0bf63ea07b1f55862947c9065#file-zgeneratedocs-py)

Hello! Today I thought I'd take on the task of reverse engineering the stats screen in Life Is Strange so I could easily request and display the data without needing to start the game. I'm documenting it here for future use, since nobody else seems to have tried this yet.

First, you'll need a copy of Life Is Strange on Steam. Second, you'll need to have it working on Linux. The Linux Steam version of LIS has a startup script that sets the ssl certificate locations, you'll need to modify that to be able to MITM the server connections. The game makes requests to https://lis.os.eidos.com, but doesn't verify the certificate in the game. (requests to Feral Interactive, the company that ported LIS to OSX and Linux, do seem to be verified, but they don't matter much)

* Set up mitmproxy on a laptop or other second computer that won't be running the game: http://docs.mitmproxy.org/en/stable/install.html
* Set up transparent proxying http://docs.mitmproxy.org/en/stable/transparent/linux.html
* Edit `.steam/steam/steamapps/common/Life Is Strange/LifeIsStrange.sh` on the first machine, and edit the lines below `HAS_CURL` like so:

```
    #HAS_CURL=$( command -v curl-config )
    #if [ -n "$...
    #    SSL_CERT_FILE=...
    #else
    #    if ...
    #        SSL_CERT...
    #    elif
    #        SSL_CERT...
    #    elif
    #        SSL_CERT...
    #    fi
    #fi
    export SSL_CERT_FILE="/home/user/Downloads/mitmproxy-ca-cert.pem"
```

* Set the second computer as the default gateway on the first computer by running `sudo ip route add default via <ip>`. Get the ip address of the second computer by running `ip addr | grep inet`.
* Close other programs (except Terminal and Steam) to minimize noise
* Run `mitmdump -w output.mitmdump` in Terminal, then start Life Is Strange through Steam
* I had to alt-tab out and into the game to get it to work, you may need to do the same
* You should see requests to /game/os\_Ping start showing up. mitmdump will record all game communication. I loaded up the main menu, clicked on Choices, waited for the stats to show up, then closed the game and killed mitmdump with ctrl-c
* Run `mitmproxy --host -r output.mitmdump` to view the requests.

If only the stats server communications weren't encrypted, would have been a lot easier.

I'm not sure how initial authentication works, the game sends an OS-AuthTicketData header with a string of characters, ~~maybe each copy of the game has a unique auth ticket~~ confirmed to be static at least for PC Linux releases. It also requests user location data via an IP info lookup (/game/os\_GetServiceInfo) and sends your friends list in the form of a list of user IDs (/game/SetUserProfileFriends), presumably for the friend stats response (/game/GetFriendsProfileStats) but this currently returns nothing. The main thing I'm interested in is /game/CommunityFactsGetEpisode, which takes a query param of i16\_episode={episode number} and returns json:

    "d" : {
        "results" : [
            {
                "__metadata" : {
                    "uri" : "https://lis.os.eidos.com/game/communityfactreturns('BirdDead')",
                    "type" : "game.communityfactreturn"
                },
                "f_rate" : "0.638969873663751",
                "i64_totalCount" : 2058,
                "i64_trueCount" : 1315,
                "i16_ep" : 1,
                "s_factID" : "BirdDead"
            },
            {
                "__metadata" : {
                    "uri" : "https://lis.os.eidos.com/game/communityfactreturns('BirdSaved')",
                    "type" : "game.communityfactreturn"
                },
                "f_rate" : "0.361030126336249",
                "i64_totalCount" : 2058,
                "i64_trueCount" : 743,
                "i16_ep" : 1,
                "s_factID" : "BirdSaved"
            }, ...

Which is exactly what I was looking for \^_\^
