Logging tests for what headers are necessary.

```
$ curl https://lis.os.eidos.com/game/CommunityFactsGetEpisode?i16_episode=3
{"s_ErrorsCodes":"501","s_ErrorsMessages":"Invalid","s_ErrorsDetails":"Missing mandatory authentication headers: (OS-AuthProvider)."}
$ curl -H "Accept: application/json" -H "OS-AuthProvider: 6" https://lis.os.eidos.com/game/CommunityFactsGetEpisode?i16_episode=3
{"s_ErrorsCodes":"501","s_ErrorsMessages":"Invalid","s_ErrorsDetails":"Missing mandatory authentication headers: (OS-AuthTicketSize, OS-AuthTicketData|OS-AuthTokenData)."}
$ curl -H "Accept: application/json" -H "OS-AuthProvider: 6" -H "OS-AuthTicketData: [redacted]" -H "OS-AuthTicketSize: 44" https://lis.os.eidos.com/game/CommunityFactsGetEpisode?i16_episode=3
{"s_ErrorsCodes":"501","s_ErrorsMessages":"Invalid","s_ErrorsDetails":"No UID header found."}
$ curl -H "Accept: application/json" -H "OS-AuthProvider: 6" -H "OS-AuthTicketData: [redacted]" -H "OS-AuthTicketSize: 44" -H "OS-UID: [redacted]" https://lis.os.eidos.com/game/CommunityFactsGetEpisode?i16_episode=3
{"s_ErrorsCodes":"801","s_ErrorsMessages":"Missing Header","s_ErrorsDetails":"HTTP header OS-Platform is required."}
$ curl -H "Accept: application/json" -H "OS-AuthProvider: 6" -H "OS-AuthTicketData: [redacted]" -H "OS-AuthTicketSize: 44" -H "OS-UID: [redacted]" -H "OS-Platform: steam"  https://lis.os.eidos.com/game/CommunityFactsGetEpisode?i16_episode=3
{"s_ErrorsCodes":"800","s_ErrorsMessages":"Invalid Header","s_ErrorsDetails":"Header OS-Platform=steam and header OS-System=null are not compatible. Either neither value or both values must be specified. If both values are specified, they must be compatible with eachother."}
$ curl -H "Accept: application/json" -H "OS-AuthProvider: 6" -H "OS-AuthTicketData: [redacted]" -H "OS-AuthTicketSize: 44" -H "OS-UID: [redacted]" -H "OS-Platform: steam" -H "OS-System: linux" https://lis.os.eidos.com/game/CommunityFactsGetEpisode?i16_episode=3
{"d" : {"results" : [{"__metadata" : {"uri" : "https://lis.os.eidos.com/game/communityfactreturns('AddedNameToVortex')", "type" : "game.communityfactreturn"}, "f_rate" : "0.610894941634241", "i64_totalCount" : 514, "i64_trueCount" : 314, "i16_ep" : 3, "s_factID" : "AddedNameToVortex"}, ...
```