import requests
import sys
import os
from bs4 import BeautifulSoup as Soup

if len(sys.argv) < 2:
    print sys.argv[0] + " <IP of server / ID of video> [ID of video] - Second arg is needed if first arg is IP"
    sys.exit(2)

CVSERVER = "10.232.66.197"
if "." in sys.argv[1]:
    CVSERVER = sys.argv[1]
    sys.argv[1] = sys.argv[2]
print "server: " + CVSERVER
if not server:
    print "Invalid server provided."
    sys.exit(2)

request = """<s:Envelope xmlns:s="http://schemas.xmlsoap.org/soap/envelope/"><s:Body><GetVideo xmlns="http://ClickView.Web.CentralWebServices.ClickViewWebPlayer"><tokenId>{id}</tokenId></GetVideo></s:Body></s:Envelope>""".format(id=sys.argv[1])

headers = {"Content-Length": len(request), "Content-Type": "text/xml", "SOAPAction": "http://ClickView.Web.CentralWebServices.ClickViewWebPlayer/IWebPlayerService/GetVideo"}

data = requests.post("http://{addr}:9053/WebPlayerService.svc".format(addr=CVSERVER), headers=headers, data=request)
soup = Soup(data.text)

chapters = soup.findAll('a:video.videochapter')
files = {}
for a in chapters:
    files[a.find('a:number').text] = {'url': a.find('a:file').text,
                                      'title': a.find('a:title').text,
                                      'ext': a.find('a:filetype').text.split(".")[-1],
                                      "vid": sys.argv[1],
                                      "fid": a.find('a:number').text}
print "got {} files".format(len(files))
with open("{}.bat".format(sys.argv[1]), "w") as f:
    for v in files.values():
        try:
            os.mkdir(v["vid"])
        except:
            pass
        f.write("wget {url} -O {vid}/{vid}-{fid}.{ext}\n".format(**v))
        print "Done {vid}/{vid}-{fid}.{ext}".format(**v)
print "done"