#!/bin/bash

PUB_URL="https://example.com/"
REMOTE="remote:path/"

cat >/tmp/cloud.conf <<EOFF
#!/bin/bash
apt-get update
apt-get install python3-pip ffmpeg -y
pip3 install youtube-dl
curl https://rclone.org/install.sh 2>/dev/null | bash

export ID=\$(curl http://169.254.169.254/metadata/v1/id 2>/dev/null)
export URL="$1"

mkdir -p /root/.config/rclone
cat > /root/.config/rclone/rclone.conf <<EOF
$(cat ~/.config/rclone/rclone.conf)
EOF

youtube-dl -f 'bestvideo[ext=mp4]+bestaudio[ext=m4a]/best[ext=mp4]/best' -o "%(id)s.%(ext)s" "\$URL"
rclone copy *.mp4 $REMOTE

echo "ALLDONE $PUB_URL"\$(ls *.mp4)
killall tail
curl -X DELETE -H "Authorization: Bearer $(grep access-token ~/.config/doctl/config.yaml | awk '{print $2}')" https://api.digitalocean.com/v2/droplets/\$ID
EOFF
read IP <<< $(set -x; doctl compute droplet create ytdl-$(date +%Y%m%d-%H%M%S) --region nyc3 --size s-1vcpu-1gb --image ubuntu-20-04-x64 --ssh-keys 31033111 --user-data-file /tmp/cloud.conf --droplet-agent=false --wait --no-header --format PublicIPv4)
rm /tmp/cloud.conf
until (ssh -o StrictHostKeyChecking=no root@$IP test -f /var/log/cloud-init-output.log); do
  sleep 1
done
ssh -o StrictHostKeyChecking=no root@$IP tail -f /var/log/cloud-init-output.log