#!/bin/bash -x
# curl s.aly.pet/ssh-setup | GIT_HOSTNAME=dotfiles.example.com GIT_USERNAME=you GIT_PASSWORD=password bash -x
if [ -z $GIT_HOSTNAME ]; then
        echo -n "Git hostname: "
        read -s GIT_HOSTNAME
fi
if [ -z $GIT_USERNAME ]; then
        echo -n "Git username: "
        read -s GIT_USERNAME
fi
if [ -z $GIT_PASSWORD ]; then
        echo -n "Git password: "
        read -s GIT_PASSWORD
fi
git --version || sudo apt install -y git || pkg install -y git || sudo pacman -Sy git || apk add git
git clone https://$GIT_USERNAME:$GIT_PASSWORD@$GIT_HOSTNAME/.ssh.git $TMPDIR/ssh_git
if [ -d $HOME/.ssh ]; then
        find $HOME/.ssh -type f -not -name authorized_keys -not -name config -not -name .gitignore -not -path "$HOME/.ssh/.git*" -exec mv -t $TMPDIR/ssh_git/ {} + && rm -rf $HOME/.ssh
fi
chown -R $UID $TMPDIR/ssh_git
find $TMPDIR/ssh_git -type f -exec chmod 600 {} +
find $TMPDIR/ssh_git -type d -exec chmod 700 {} +
mv $TMPDIR/ssh_git $HOME/.ssh