#!/usr/bin/env python3
import sqlite3
from sys import argv
from requests import get,post
lib = argv[1]
ROOT = "/mnt/storage/_live/{}library.db"
QBT = "http://localhost:8080"

con = sqlite3.connect(ROOT.format(lib))
cur = con.cursor()
cur.execute("CREATE TABLE IF NOT EXISTS file(hash,'index',size,availability,priority,progress,name)")

j = get(f"{QBT}/api/v2/sync/maindata?rid=0").json()
torrents = {t:v for t,v in j["torrents"].items() if v["category"] == f"{lib}library" and "attn" in v["tags"]}

for n,hash in enumerate(torrents):
  if "files" not in torrents[hash]:
    torrents[hash]["files"] = get(f"{QBT}/api/v2/torrents/files",params={"hash": hash}).json()
    print(n,len(torrents[hash]["files"]))

inp = []
for hash in torrents:
  for file in torrents[hash]["files"]:
    inp.append((hash,file['index'],file['size'],file['availability'],file['priority'],file['progress'],file['name']))

cur.executemany("INSERT INTO file VALUES(?,?,?,?,?,?,?)",inp)
con.commit()
con.close()