#!/usr/bin/env -S python3 -i
from requests import post
from tabulate import tabulate
from sys import argv
lib = argv[1]
ROOT = "/mnt/storage/_live/{}library.db"
QBT = "http://localhost:8080"

import sqlite3
con = sqlite3.connect(ROOT.format(lib))
cur = con.cursor()

class SORT:
    filename=0
    size=1
    pack=2

def add(hash,_id):
  post(f"{QBT}/api/v2/torrents/filePrio", data={"hash": hash, "id": _id, "priority": 1})
  post(f"{QBT}/api/v2/torrents/addTags", data={"hashes": hash, "tags": "attn"})
  post(f"{QBT}/api/v2/torrents/start", data={"hashes": hash})
  print(f"added {hash}:{_id}")

def search(query,*n,sort=SORT.pack):
  rows = []
  data = []
  for a,b,c,d in cur.execute("select hash,`index`,name,size from file where name like ? order by name", (f"%{query}%",)):
    _ = c.split("/")
    rows.append([_[-1],f"{d/1024/1024:.2f}M",_[0],a,b])
  outp = [[n, *row] for n,row in enumerate(sorted(rows,key=lambda row: row[sort]))]
  for pick in n:
    print(f"adding {outp[pick][1]}...")
    add(*outp[pick][-2:])
#  if x in n or "*" in n:
#    add(a,b)
  if not n: print(tabulate([row[:-2] for row in outp], headers=["n",f"filename{' ^' if sort==SORT.filename else ''}",f"size{' ^' if sort==SORT.size else ''}",f"pack{' ^' if sort==SORT.pack else ''}"]))